/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlobStoreInterface;
import com.mckoi.database.DataIndexSetDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.FixedRecordList;
import com.mckoi.database.IndexSet;
import com.mckoi.database.IndexSetStore;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.MultiVersionTableIndices;
import com.mckoi.database.OpenTransactionList;
import com.mckoi.database.RIDList;
import com.mckoi.database.RowData;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.V1MasterTableDataSource;
import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.global.Ref;
import com.mckoi.store.AbstractStore;
import com.mckoi.store.Area;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.UserTerminal;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class V2MasterTableDataSource
extends MasterTableDataSource {
    private String file_name;
    private Store store;
    private IndexSetStore index_store;
    private long sequence_id;
    private long index_header_p;
    private long list_header_p;
    private MutableArea header_area;
    private FixedRecordList list_structure;
    private long first_delete_chain_record = -1L;
    private boolean has_shutdown = false;
    private short s_run_file_hits = Short.MAX_VALUE;

    public V2MasterTableDataSource(TransactionSystem system, StoreSystem store_system, OpenTransactionList open_transactions, BlobStoreInterface blob_store_interface) {
        super(system, store_system, open_transactions, blob_store_interface);
    }

    private static DataOutputStream getDOut(OutputStream out) {
        return new DataOutputStream(new BufferedOutputStream(out, 512));
    }

    private static DataInputStream getDIn(InputStream in) {
        return new DataInputStream(new BufferedInputStream(in, 512));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInitialStore() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(1);
        this.getDataTableDef().write(dout);
        byte[] data_table_def_buf = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        dout = new DataOutputStream(bout);
        dout.writeInt(1);
        this.getDataIndexSetDef().write(dout);
        byte[] index_set_def_buf = bout.toByteArray();
        bout = null;
        dout = null;
        try {
            this.store.lockForWrite();
            AreaWriter header_writer = this.store.createArea(80L);
            long header_p = header_writer.getID();
            AreaWriter data_table_def_writer = this.store.createArea(data_table_def_buf.length);
            long data_table_def_p = data_table_def_writer.getID();
            AreaWriter data_index_set_writer = this.store.createArea(index_set_def_buf.length);
            long data_index_set_def_p = data_index_set_writer.getID();
            this.list_header_p = this.list_structure.create();
            this.list_structure.setReservedLong(-1L);
            this.first_delete_chain_record = -1L;
            this.index_store = new IndexSetStore(this.store, this.getSystem());
            this.index_header_p = this.index_store.create();
            header_writer.putInt(1);
            header_writer.putInt(this.table_id);
            header_writer.putLong(this.sequence_id);
            header_writer.putLong(data_table_def_p);
            header_writer.putLong(data_index_set_def_p);
            header_writer.putLong(this.index_header_p);
            header_writer.putLong(this.list_header_p);
            header_writer.finish();
            data_table_def_writer.put(data_table_def_buf);
            data_table_def_writer.finish();
            data_index_set_writer.put(index_set_def_buf);
            data_index_set_writer.finish();
            MutableArea fixed_area = this.store.getMutableArea(-1L);
            fixed_area.putLong(header_p);
            fixed_area.checkOut();
            this.header_area = this.store.getMutableArea(header_p);
            Object var16_12 = null;
            this.store.unlockForWrite();
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
    }

    private void readStoreHeaders() throws IOException {
        Area fixed_area = this.store.getArea(-1L);
        this.header_area = this.store.getMutableArea(fixed_area.getLong());
        int version = this.header_area.getInt();
        if (version != 1) {
            throw new IOException("Incorrect version identifier.");
        }
        this.table_id = this.header_area.getInt();
        this.sequence_id = this.header_area.getLong();
        long def_p = this.header_area.getLong();
        long index_def_p = this.header_area.getLong();
        this.index_header_p = this.header_area.getLong();
        this.list_header_p = this.header_area.getLong();
        DataInputStream din = V2MasterTableDataSource.getDIn(this.store.getAreaInputStream(def_p));
        version = din.readInt();
        if (version != 1) {
            throw new IOException("Incorrect DataTableDef version identifier.");
        }
        this.table_def = DataTableDef.read(din);
        din.close();
        din = V2MasterTableDataSource.getDIn(this.store.getAreaInputStream(index_def_p));
        version = din.readInt();
        if (version != 1) {
            throw new IOException("Incorrect DataIndexSetDef version identifier.");
        }
        this.index_def = DataIndexSetDef.read(din);
        din.close();
        this.list_structure.init(this.list_header_p);
        this.first_delete_chain_record = this.list_structure.getReservedLong();
        this.index_store = new IndexSetStore(this.store, this.getSystem());
        try {
            this.index_store.init(this.index_header_p);
        }
        catch (IOException e) {
            this.index_store = new IndexSetStore(this.store, this.getSystem());
            this.index_header_p = this.index_store.create();
            this.index_store.addIndexLists(this.table_def.columnCount() + 1, 1, 1024);
            this.header_area.position(32);
            this.header_area.putLong(this.index_header_p);
            this.header_area.position(0);
            this.header_area.checkOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create(int table_id, DataTableDef table_def) throws IOException {
        this.setupDataTableDef(table_def);
        this.sequence_id = 1L;
        this.file_name = V2MasterTableDataSource.makeTableFileName(this.getSystem(), table_id, this.getTableName());
        this.store = this.storeSystem().createStore(this.file_name);
        try {
            this.store.lockForWrite();
            this.list_structure = new FixedRecordList(this.store, 12);
            Object var4_3 = null;
            this.store.unlockForWrite();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
        this.table_id = table_id;
        this.setupInitialStore();
        this.index_store.addIndexLists(table_def.columnCount() + 1, 1, 1024);
        this.loadInternal();
    }

    boolean exists(String identity) throws IOException {
        return this.storeSystem().storeExists(identity);
    }

    public void open(String file_name) throws IOException {
        this.file_name = file_name;
        this.store = this.storeSystem().openStore(file_name);
        boolean need_check = !this.store.lastCloseClean();
        this.list_structure = new FixedRecordList(this.store, 12);
        this.readStoreHeaders();
        this.column_count = this.table_def.columnCount();
        this.table_indices = new MultiVersionTableIndices(this.getSystem(), this.table_def.getTableName(), this.table_def.columnCount());
        this.column_rid_list = new RIDList[this.table_def.columnCount()];
        this.loadInternal();
        if (need_check) {
            this.doOpeningScan();
            this.Debug().write(10, this, "Scanning File: " + file_name + " for leaks.");
            this.scanForLeaks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(boolean pending_drop) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            this.clearAllRootLocks();
            try {
                try {
                    this.store.lockForWrite();
                    if (!this.isReadOnly()) {
                        this.garbage_collector.performCollectionEvent(true);
                    }
                    if (pending_drop) {
                        this.dropAllBlobReferences();
                    }
                    Object var4_3 = null;
                    this.store.unlockForWrite();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.store.unlockForWrite();
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.Debug().write(40, this, "Exception during table (" + this.toString() + ") close: " + e.getMessage());
                this.Debug().writeException(e);
            }
            this.index_store.close();
            this.storeSystem().closeStore(this.store);
            this.table_def = null;
            this.table_indices = null;
            this.column_rid_list = null;
            this.is_closed = true;
        }
    }

    void copy(int table_id, MasterTableDataSource src_master_table, IndexSet index_set) throws IOException {
        this.create(table_id, src_master_table.getDataTableDef());
        IntegerListInterface master_index = index_set.getIndex(0);
        int sz = src_master_table.rawRowCount();
        for (int i = 0; i < sz; ++i) {
            if (!master_index.contains(i)) continue;
            this.copyRecordFrom(src_master_table, i);
        }
        if (src_master_table instanceof V2MasterTableDataSource) {
            this.index_store.copyAllFrom(index_set);
        } else if (src_master_table instanceof V1MasterTableDataSource) {
            this.buildIndexes();
        }
        long un_id = src_master_table.nextUniqueID();
        this.setUniqueID(un_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeRecordToStore(RowData data) throws IOException {
        int row_cells = data.getColumnCount();
        int[] cell_sizes = new int[row_cells];
        int[] cell_type = new int[row_cells];
        try {
            int i;
            this.store.lockForWrite();
            int all_records_size = 0;
            for (int i2 = 0; i2 < row_cells; ++i2) {
                int ctype;
                int sz;
                TObject cell = data.getCellData(i2);
                if (cell.getObject() instanceof Ref) {
                    Ref large_object_ref = (Ref)cell.getObject();
                    sz = 16;
                    ctype = 2;
                    if (large_object_ref != null) {
                        this.blob_store_interface.establishReference(large_object_ref.getID());
                    }
                } else {
                    sz = ObjectTransfer.exactSize(cell.getObject());
                    ctype = 1;
                }
                cell_sizes[i2] = sz;
                cell_type[i2] = ctype;
                all_records_size += sz;
            }
            AreaWriter writer = this.store.createArea(all_records_size + row_cells * 8 + 4);
            long record_p = writer.getID();
            DataOutputStream dout = V2MasterTableDataSource.getDOut(writer.getOutputStream());
            dout.writeInt(0);
            int cell_skip = 0;
            for (i = 0; i < row_cells; ++i) {
                dout.writeInt(cell_type[i]);
                dout.writeInt(cell_skip);
                cell_skip += cell_sizes[i];
            }
            for (i = 0; i < row_cells; ++i) {
                TObject t_object = data.getCellData(i);
                int ctype = cell_type[i];
                if (ctype == 1) {
                    ObjectTransfer.writeTo(dout, t_object.getObject());
                    continue;
                }
                if (ctype == 2) {
                    Ref large_object_ref = (Ref)t_object.getObject();
                    if (large_object_ref == null) {
                        dout.writeInt(1);
                        dout.writeInt(0);
                        dout.writeLong(-1L);
                        continue;
                    }
                    dout.writeInt(0);
                    dout.writeInt(0);
                    dout.writeLong(large_object_ref.getID());
                    continue;
                }
                throw new IOException("Unrecognised cell type.");
            }
            dout.flush();
            writer.finish();
            long l = record_p;
            Object var16_20 = null;
            this.store.unlockForWrite();
            return l;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRecordFrom(MasterTableDataSource src_master_table, int record_id) throws IOException {
        int sz = src_master_table.getDataTableDef().columnCount();
        RowData row_data = new RowData(this.getSystem(), sz);
        for (int i = 0; i < sz; ++i) {
            TObject tob = src_master_table.getCellContents(i, record_id);
            row_data.setColumnDataFromTObject(i, tob);
        }
        try {
            this.store.lockForWrite();
            long record_p = this.writeRecordToStore(row_data);
            this.addToRecordList(record_id, record_p);
            this.writeRecordType(record_id, 16);
            Object var8_8 = null;
            this.store.unlockForWrite();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
    }

    private void removeAllBlobReferencesForRecord(long record_p) throws IOException {
        Area record_area = this.store.getArea(record_p);
        int reserved = record_area.getInt();
        for (int i = 0; i < this.column_count; ++i) {
            int ctype = record_area.getInt();
            int cell_offset = record_area.getInt();
            if (ctype == 1) continue;
            if (ctype == 2) {
                int cur_p = record_area.position();
                record_area.position(cell_offset + 4 + this.column_count * 8);
                int btype = record_area.getInt();
                record_area.getInt();
                if (btype == 0) {
                    long blob_ref_id = record_area.getLong();
                    this.blob_store_interface.releaseReference(blob_ref_id);
                }
                record_area.position(cur_p);
                continue;
            }
            throw new RuntimeException("Unrecognised type.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAllBlobReferences() throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            long elements = this.list_structure.addressableNodeCount();
            for (long i = 0L; i < elements; ++i) {
                MutableArea a = this.list_structure.positionOnNode(i);
                int status = a.getInt();
                if ((status & 0x20000) != 0) continue;
                long record_p = a.getLong();
                this.removeAllBlobReferencesForRecord(record_p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForLeaks() throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            ArrayList<Long> used_areas = new ArrayList<Long>();
            used_areas.add(new Long(this.header_area.getID()));
            this.header_area.position(16);
            used_areas.add(new Long(this.header_area.getLong()));
            used_areas.add(new Long(this.header_area.getLong()));
            this.list_structure.addAllAreasUsed(used_areas);
            this.index_store.addAllAreasUsed(used_areas);
            long elements = this.list_structure.addressableNodeCount();
            for (long i = 0L; i < elements; ++i) {
                MutableArea a = this.list_structure.positionOnNode(i);
                int status = a.getInt();
                if ((status & 0x20000) != 0) continue;
                long pointer = a.getLong();
                used_areas.add(new Long(pointer));
            }
            if (this.store instanceof AbstractStore) {
                AbstractStore a_store = (AbstractStore)this.store;
                ArrayList leaked_areas = a_store.findAllocatedAreasNotIn(used_areas);
                if (leaked_areas.size() == 0) {
                    this.Debug().write(10, this, "No leaked areas.");
                } else {
                    this.Debug().write(10, this, "There were " + leaked_areas.size() + " leaked areas found.");
                    for (int n = 0; n < leaked_areas.size(); ++n) {
                        Long area_pointer = (Long)leaked_areas.get(n);
                        this.store.deleteArea(area_pointer);
                    }
                    this.Debug().write(10, this, "Leaked areas successfully freed.");
                }
            }
        }
    }

    public void checkAndRepair(String file_name, UserTerminal terminal) throws IOException {
        this.file_name = file_name;
        terminal.println("+ Repairing V2MasterTableDataSource " + file_name);
        this.store = this.storeSystem().openStore(file_name);
        if (this.store instanceof AbstractStore) {
            ((AbstractStore)this.store).openScanAndFix(terminal);
        }
        this.list_structure = new FixedRecordList(this.store, 12);
        try {
            this.readStoreHeaders();
            this.column_count = this.table_def.columnCount();
        }
        catch (IOException e) {
            terminal.println("! Table is not repairable because the file headers are corrupt.");
            terminal.println("  Error reported: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        terminal.println("- Checking record integrity.");
        List all_areas = this.store.getAllAreas();
        ArrayList<Long> all_records = new ArrayList<Long>();
        this.first_delete_chain_record = -1L;
        int record_count = 0;
        int free_count = 0;
        int sz = this.rawRowCount();
        for (int i = sz - 1; i >= 0; --i) {
            boolean record_valid = this.checkAndRepairRecord(i, all_areas, terminal);
            if (record_valid) {
                all_records.add(new Long(i));
                ++record_count;
                continue;
            }
            ++free_count;
        }
        this.list_structure.setReservedLong(this.first_delete_chain_record);
        terminal.print("* Record count = " + record_count);
        terminal.println(" Free count = " + free_count);
        terminal.println("- Rebuilding all table index information.");
        int index_count = this.table_def.columnCount() + 1;
        for (int i = 0; i < index_count; ++i) {
            this.index_store.commitDropIndex(i);
        }
        this.buildIndexes();
        terminal.println("- Table check complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndRepairRecord(int row_index, List all_areas, UserTerminal terminal) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            MutableArea block_area = this.list_structure.positionOnNode(row_index);
            int p = block_area.position();
            int status = block_area.getInt();
            if ((status & 0x20000) == 0) {
                long record_p = block_area.getLong();
                int i = Collections.binarySearch(all_areas, new Long(record_p));
                if (i >= 0) {
                    try {
                        this.internalGetCellContents(0, row_index);
                        return true;
                    }
                    catch (Throwable e) {
                        terminal.println("+ Error accessing record: " + e.getMessage());
                    }
                }
                terminal.println("+ Record area not valid: row = " + row_index + " pointer = " + record_p);
                terminal.println("+ Deleting record.");
            }
            block_area.position(p);
            block_area.putInt(131072);
            block_area.putLong(this.first_delete_chain_record);
            block_area.checkOut();
            this.first_delete_chain_record = row_index;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growListStructure() throws IOException {
        try {
            this.store.lockForWrite();
            this.list_structure.increaseSize();
            int new_block_number = this.list_structure.listBlockCount() - 1;
            long start_index = this.list_structure.listBlockFirstPosition(new_block_number);
            long size_of_block = this.list_structure.listBlockNodeCount(new_block_number);
            MutableArea a = this.list_structure.positionOnNode(start_index);
            for (long n = 0L; n < size_of_block - 1L; ++n) {
                a.putInt(131072);
                a.putLong(start_index + n + 1L);
            }
            a.putInt(131072);
            a.putLong(this.first_delete_chain_record);
            a.checkOut();
            this.first_delete_chain_record = start_index;
            this.list_structure.setReservedLong(this.first_delete_chain_record);
            Object var10_6 = null;
            this.store.unlockForWrite();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addToRecordList(long index, long record_p) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            MutableArea a;
            if (this.has_shutdown) {
                throw new IOException("IO operation while VM shutting down.");
            }
            long addr_count = this.list_structure.addressableNodeCount();
            while (index >= addr_count) {
                this.growListStructure();
                addr_count = this.list_structure.addressableNodeCount();
            }
            long prev = -1L;
            long chain = this.first_delete_chain_record;
            while (chain != -1L && chain != index) {
                a = this.list_structure.positionOnNode(chain);
                if (a.getInt() == 131072) {
                    prev = chain;
                    chain = a.getLong();
                    continue;
                }
                throw new IOException("Not deleted record is in delete chain!");
            }
            if (chain == -1L) {
                throw new IOException("Unable to add record because index is not available.");
            }
            a = this.list_structure.positionOnNode(chain);
            if (a.getInt() != 131072) {
                throw new IOException("Not deleted record is in delete chain!");
            }
            long next_p = a.getLong();
            try {
                MutableArea ma;
                this.store.lockForWrite();
                if (prev == -1L) {
                    this.first_delete_chain_record = next_p;
                    this.list_structure.setReservedLong(this.first_delete_chain_record);
                } else {
                    ma = this.list_structure.positionOnNode(prev);
                    ma.putInt(131072);
                    ma.putLong(next_p);
                    ma.checkOut();
                }
                ma = this.list_structure.positionOnNode(index);
                ma.putInt(0);
                ma.putLong(record_p);
                ma.checkOut();
                Object var17_10 = null;
                this.store.unlockForWrite();
            }
            catch (Throwable throwable) {
                Object var17_11 = null;
                this.store.unlockForWrite();
                throw throwable;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addToRecordList(long record_p) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            long next_chain;
            if (this.has_shutdown) {
                throw new IOException("IO operation while VM shutting down.");
            }
            if (this.first_delete_chain_record == -1L) {
                this.growListStructure();
            }
            long recycled_record = this.first_delete_chain_record;
            MutableArea block = this.list_structure.positionOnNode(recycled_record);
            int rec_pos = block.position();
            int status = block.getInt();
            if ((status & 0x20000) == 0) {
                throw new Error("Assertion failed: record is not deleted.  status = " + status + ", rec_pos = " + rec_pos);
            }
            this.first_delete_chain_record = next_chain = block.getLong();
            try {
                this.store.lockForWrite();
                this.list_structure.setReservedLong(this.first_delete_chain_record);
                block.position(rec_pos);
                block.putInt(0);
                block.putLong(record_p);
                block.checkOut();
                Object var12_8 = null;
                this.store.unlockForWrite();
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                this.store.unlockForWrite();
                throw throwable;
            }
            return recycled_record;
        }
    }

    String getSourceIdent() {
        return this.file_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeRecordType(int row_index, int row_state) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            if (this.has_shutdown) {
                throw new IOException("IO operation while VM shutting down.");
            }
            MutableArea block_area = this.list_structure.positionOnNode(row_index);
            int pos = block_area.position();
            int old_status = block_area.getInt();
            int mod_status = old_status & 0xFFFF0000 | row_state & 0xFFFF;
            try {
                this.store.lockForWrite();
                block_area.position(pos);
                block_area.putInt(mod_status);
                block_area.checkOut();
                Object var9_8 = null;
                this.store.unlockForWrite();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.store.unlockForWrite();
                throw throwable;
            }
            return old_status & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readRecordType(int row_index) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            MutableArea block_area = this.list_structure.positionOnNode(row_index);
            return block_area.getInt() & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recordDeleted(int row_index) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            MutableArea block_area = this.list_structure.positionOnNode(row_index);
            return (block_area.getInt() & 0x20000) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int rawRowCount() throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            long total = this.list_structure.addressableNodeCount();
            return (int)total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDeleteRow(int row_index) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            if (this.has_shutdown) {
                throw new IOException("IO operation while VM shutting down.");
            }
            MutableArea block_area = this.list_structure.positionOnNode(row_index);
            int p = block_area.position();
            int status = block_area.getInt();
            if ((status & 0x20000) != 0) {
                throw new IOException("Record is already marked as deleted.");
            }
            long record_p = block_area.getLong();
            try {
                this.store.lockForWrite();
                block_area.position(p);
                block_area.putInt(131072);
                block_area.putLong(this.first_delete_chain_record);
                block_area.checkOut();
                this.first_delete_chain_record = row_index;
                this.list_structure.setReservedLong(this.first_delete_chain_record);
                this.removeAllBlobReferencesForRecord(record_p);
                this.store.deleteArea(record_p);
                Object var9_7 = null;
                this.store.unlockForWrite();
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.store.unlockForWrite();
                throw throwable;
            }
        }
    }

    IndexSet createIndexSet() {
        return this.index_store.getSnapshotIndexSet();
    }

    void commitIndexSet(IndexSet index_set) {
        this.index_store.commitIndexSet(index_set);
        index_set.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalAddRow(RowData data) throws IOException {
        int int_row_number;
        long row_number;
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            long record_p = this.writeRecordToStore(data);
            row_number = this.addToRecordList(record_p);
            int_row_number = (int)row_number;
        }
        if (this.DATA_CELL_CACHING) {
            int row_cells = data.getColumnCount();
            for (int i = 0; i < row_cells; ++i) {
                this.cache.put(this.table_id, int_row_number, i, data.getCellData(i));
            }
        }
        return (int)row_number;
    }

    synchronized void checkForCleanup() {
        this.garbage_collector.performCollectionEvent(false);
    }

    private void skipStream(InputStream in, long amount) throws IOException {
        long count = amount;
        long skipped = 0L;
        while (skipped < amount) {
            long last_skipped = in.skip(count);
            skipped += last_skipped;
            count -= last_skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TObject internalGetCellContents(int column, int row) {
        TObject cell;
        if (this.DATA_CELL_CACHING && (cell = this.cache.get(this.table_id, row, column)) != null) {
            return cell;
        }
        long record_p = -1L;
        try {
            Object ob;
            FixedRecordList fixedRecordList = this.list_structure;
            synchronized (fixedRecordList) {
                MutableArea list_block;
                int status;
                this.s_run_file_hits = (short)(this.s_run_file_hits + 1);
                if (this.s_run_file_hits >= 100) {
                    this.getSystem().stats().add(this.s_run_file_hits, this.file_hits_key);
                    this.s_run_file_hits = 0;
                }
                if (((status = (list_block = this.list_structure.positionOnNode(row)).getInt()) & 0x20000) != 0) {
                    throw new Error("Unable to read deleted record.");
                }
                record_p = list_block.getLong();
            }
            DataInputStream din = V2MasterTableDataSource.getDIn(this.store.getAreaInputStream(record_p));
            this.skipStream(din, 4 + column * 8);
            int cell_type = din.readInt();
            int cell_offset = din.readInt();
            int cur_at = 12 + column * 8;
            int be_at = 4 + this.column_count * 8;
            int skip_amount = be_at - cur_at + cell_offset;
            this.skipStream(din, skip_amount);
            if (cell_type == 1) {
                ob = ObjectTransfer.readFrom(din);
            } else {
                if (cell_type != 2) throw new RuntimeException("Unrecognised cell type in data.");
                int f_type = din.readInt();
                int f_reserved = din.readInt();
                long ref_id = din.readLong();
                if (f_type == 0) {
                    ob = this.blob_store_interface.getLargeObject(ref_id);
                } else {
                    if (f_type != 1) throw new RuntimeException("Unknown blob type.");
                    ob = null;
                }
            }
            TType ttype = this.getDataTableDef().columnAt(column).getTType();
            cell = new TObject(ttype, ob);
            din.close();
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("IOError getting cell at (" + column + ", " + row + ") pointer = " + record_p + ".");
        }
        if (!this.DATA_CELL_CACHING) return cell;
        this.cache.put(this.table_id, row, column, cell);
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long currentUniqueID() {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            return this.sequence_id - 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextUniqueID() {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            long v = this.sequence_id++;
            if (this.has_shutdown) {
                throw new RuntimeException("IO operation while VM shutting down.");
            }
            try {
                try {
                    this.store.lockForWrite();
                    this.header_area.position(8);
                    this.header_area.putLong(this.sequence_id);
                    this.header_area.checkOut();
                    Object var5_3 = null;
                    this.store.unlockForWrite();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.store.unlockForWrite();
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.Debug().writeException(e);
                throw new Error("IO Error: " + e.getMessage());
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUniqueID(long value) {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            this.sequence_id = value;
            if (this.has_shutdown) {
                throw new RuntimeException("IO operation while VM shutting down.");
            }
            try {
                try {
                    this.store.lockForWrite();
                    this.header_area.position(8);
                    this.header_area.putLong(this.sequence_id);
                    this.header_area.checkOut();
                    Object var5_3 = null;
                    this.store.unlockForWrite();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.store.unlockForWrite();
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.Debug().writeException(e);
                throw new Error("IO Error: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void dispose(boolean pending_drop) throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            if (!this.is_closed) {
                this.close(pending_drop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean drop() throws IOException {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            boolean b;
            if (!this.is_closed) {
                this.close(true);
            }
            if (b = this.storeSystem().deleteStore(this.store)) {
                this.Debug().write(10000, this, "Dropped: " + this.getSourceIdent());
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownHookCleanup() {
        FixedRecordList fixedRecordList = this.list_structure;
        synchronized (fixedRecordList) {
            this.index_store.close();
            this.has_shutdown = true;
        }
    }

    boolean isWorthCompacting() {
        return true;
    }

    public String toString() {
        return "[V2MasterTableDataSource: " + this.file_name + "]";
    }
}

